//Finding the CDF and pdf of a discrete random variable from its pmf
//Windows 10
//Scilab 6.1.0
clear
clc
x=input('Enter the values taken by Random Variable:')
p=input('Enter the probabilities:')
//computation of CDF values
for i=2:length(x)
    p(i)=p(i)+p(i-1);
end
x1=min(x)-1:0.01:max(x)+2;
cdf=zeros(1,length(x1));
cdf(find(x1==max(x)):length(x1))=1;
//creating CDF vector
for i=1:length(x)-1
    cdf(find(x1==x(i)):find(x1==x(i+1)))=p(i);
end
//computation of pdf
pdf=diff(cdf);
pdf(length(pdf)+1)=0;
subplot(2,1,1)
xset("thickness",3)
plot2d2(x1,cdf,rect=[min(x1) min(p)-0.5 max(x1) max(p)+0.25 ])
a=gca();
a.x_location="origin";
a.y_location="origin";
xtitle('Plot of CDF','values taken by the random variable','Cumulative Distribution Function')
legend("x=[-1 1 3 5] , p=[1/2 1/8 1/8 1/4 ]",4)
xstring(x1(find(x1==-1)),cdf(find(cdf==1/2)),["0.5"])
xstring(x1(find(x1==1)),cdf(find(cdf==0.625)),["0.625"])
xstring(x1(find(x1==3)),cdf(find(cdf==0.75)),["0.75"])
xstring(x1(find(x1==5)),cdf(find(cdf==1)),["1"])
subplot(2,1,2)
xset("thickness",3)
plot2d3(x1,pdf ,rect=[min(x1) 0 max(x1) max(p) ])
b=gca();
b.x_location="origin";
b.y_location="origin";
xtitle('Plot of pdf','values taken by the random variable','Probability Density Function')
legend("Probability Density Function")
xstring(x1(find(x1==-1)),pdf(find(pdf==1/2)),["1/2"])
xstring(x1(find(x1==1)),pdf(find(pdf==1/8)),["1/8"])
xstring(x1(find(x1==3)),pdf(find(pdf==1/8)),["1/8"])
xstring(x1(find(x1==5)),pdf(find(pdf==1/4)),["1/4"])

//output testcase
//values taken by Random Variable:[-1 1 3 5]
//probabilities:[1/2 1/8 1/8 1/4]
// If the probabilities are changed, the xstring statements are to be modified accordingly
